;*****************************************************************************************************************************************
;Source File Name:
;		magGmw4.jss
;Author's Name:
;		Ben Key 
;Description:
;		JFW script file used to encapsulate MAGic tracking related scripts and functions that need
;		to be loaded with the Goldminw script set into their own file.  This was done to aid in keeping
; 		MAGic and JFW scripts seperate from each other and to improve the maintainability of the MAGic
; 		tracking project.
;Included Header Files:
;		hjconst.jsh			default HJ constants 
;		hjglobal.jsh		default HJ global variables
;		default.jsm			included for default MAGic messages
;		magCodes.jsh	constants for MAGic commands and key events
; 		magic.jsh			Constants and globals used by the magic tracking functions
;		gmw4.jsh			Constants and globals that are specific to GoldMine
;		gmw4.jsm			Contains message string constants that are specific to GoldMine
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;						                          MODIFICATION LOG
;
;Date						Author						Description
;----------------			---------------				-------------------------------------------------------------
;08/23/1999			Ben Key					magGmw4.jss added to the MAGic Tracking project.
;08/23/1999			Ben Key					FocusPointMagEvent (...) added to magGmw4.jss
;08/23/1999			Ben Key					DidControlChange () added to magGmw4.jss
;*****************************************************************************************************************************************


Include "hjglobal.jsh" ; default HJ global variables
Include "hjconst.jsh" ; default HJ constants
Include "default.jsm"
Include "magCodes.jsh"
Include "magic.jsh"
include "gmw4.jsh"
include "gmw4.jsm"

Globals
	Int nTop,
	Int nLeft

Int Function DidControlChange ()
Var Handle prevWinHandle, Int nPrevLeft, Int nPrevTop
If (!MagGetState ()) then Return EndIf
Let prevWinHandle = cwHandle
Let cwHandle = GetCurrentWindow ()
Let nPrevLeft = nLeft
Let nPrevTop = nTop
Let nLeft = GetWindowLeft (cwHandle)
Let nTop = GetWindowTop (cwHandle)
SaveCursor ()
JawsCursor ()
MoveTo (nLeft, NTop)
RestoreCursor ()
If ((GetWindowName (GetRealWindow (GetFocus ())) == mWN_MAppWin)
	|| (GetWindowSubtypeCode (GetRealWindow (GetFocus ())) == WT_DIALOG)
	|| (DialogActive () == ACTIVE)) then
	If (GlobalMenuMode == MENU_INACTIVE) then
		If (cwHandle != prevWinHandle
			|| nPrevLeft != nLeft
			|| nPrevTop != nTop) then 
			Return 1
		Else
			Return 0
		EndIf
	Else
		Return 0
	EndIf
Else 
	Return 0
EndIf
EndFunction

Int Function TrackDialogBoxes (int nX, int nY, int nOldX, int nOldY, int nUnit, int nDir, int nTimeElapsed, Int TheTypeCode, String cwClass, Handle appWindow)
;  This function is called by MagSetFocusArea to handle MAGic tracking in dialog boxes
Var int nH,  int nW, Int nL, Int nR, Int nT, Int nB, Int nLevel, Int nMaxWidth, Int bSuccess
If (GlobalMenuMode != MENU_INACTIVE) then Return 0 EndIf
Let nLevel = MagGetOption (MID_LEVEL)
Let nMaxWidth = ScreenGetWidth () / nLevel
GetWindowRect (GetRealWindow (GetFocus ()), nL, nR, nT, nB)
Let nH = nB - nT
Let nW = nR - nL
If (TestDialogSize (nW, nH) == 1
	&& cwClass != WCField) then
	MagSetFocusToRect (nL, nR, nT, nB, MTO_DIALOG)
	Return 1
Else
	If (TheTypeCode == WT_LISTVIEW) then
		Let bSuccess = TrackListView (nX, nY, nOldX, nOldY, nUnit, nDir, nTimeElapsed, TheTypeCode, cwClass, appWindow, 0)
		Return bSuccess
	EndIf
	If (nLevel < DialogControlAndPromptMax) then
		If (GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT | IT_PROMPT)) then
			If (nT <= 3) Then Let nT = 0 Else Let nT = nT - 3 EndIf
			If (nL <= 3) Then Let nL = 0 Else Let nL = nL - 3 EndIf
			If ((nR - nL) > nMaxWidth) then
				GetItemRect (nX, nY, 0, nR, 0, 0, IT_PRIOR_WORD | IT_WORD)
			EndIf
			If ((nX - nL) > nMaxWidth - 5) then
				GetItemRect (nX, nY, nL, nR, nT, nB, IT_PRIOR_WORD | IT_WORD)
			EndIf
			MagSetFocusToRect (nL, nR + 3, nT, nB + 3, MTO_DIALOG)
			Return 1
		ElIf (GetDialogControlRect (nY, nY, nL, nR, nT, nB, IT_PROMPT | IT_BOUNDINGRECT, 0)) then
			If (nT <= 3) Then Let nT = 0 Else Let nT = nT - 3 EndIf
			If (nL <= 3) Then Let nL = 0 Else Let nL = nL - 3 EndIf
			MagSetFocusToRect (nL, nR + 3, nT, nB + 3, MTO_DIALOG)
			Return 1
		Else Return 0 EndIf
	Else
		If (GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT)) then
			If (nT <= 3) Then Let nT = 0 Else Let nT = nT - 3 EndIf
			If (nL <= 3) Then Let nL = 0 Else Let nL = nL - 3 EndIf
			MagSetFocusToRect (nL, nR + 3, nT, nB + 3, MTO_DIALOG)
			Return 1
		ElIf (GetDialogControlRect (nY, nY, nL, nR, nT, nB, IT_BOUNDINGRECT, 0)) then
			If (nT <= 3) Then Let nT = 0 Else Let nT = nT - 3 EndIf
			If (nL <= 3) Then Let nL = 0 Else Let nL = nL - 3 EndIf
			MagSetFocusToRect (nL, nR + 3, nT, nB + 3, MTO_DIALOG)
			Return 1
		Else Return 0 EndIf
	EndIf
EndIf
EndFunction


;*****************************************************************************************************************************************
;Event Function:	
;		Void Function FocusPointMovedMagEvent (int nX, int nY, int nOldX, int nOldY, int nUnit, int nDir, int nTimeElapsed)
;Author's Name:
;		Ben Key
;Description:
;		This function is designed to control MAGic tracking when FocusPointMovedMagEvent is called within certian windows 
;		within the GoldMine Environment.
;Parameters:
;		int	nX								The X coordinate of the cursor after the change in focus point
;		int	nY								The Y coordinate of the cursor after the change in focus point
;		int	nOldX						The X coordinate of the cursor before the change in focus point
;		int	nOldY						The Y coordinate of the cursor before the change in focus point
;		int	nUnit							The unit of movement as defined in HJConst.jsh
;		int	nDir							The direction of movement as defined in HJConst.jsh
;		int	nTimeElapsed		The amount of time that has elapsed since the movement occured
;Globals
;	Used:
;	Modified:
;Return Value:		
;	Void
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date						Author						Description
;-----------------		---------------				--------------------------------------------------------------------------
;08/23/1999			Ben Key					FocusPointMagEvent (...) added to magGmw4.jss
;*****************************************************************************************************************************************
Void Function FocusPointMovedMagEvent (int nX, int nY, int nOldX, int nOldY, int nUnit, int nDir, int nTimeElapsed)
;  This function first tests for the existance of MAGic.  If MAGic is running, it then determines
;  the current window type.  If the current window type is an edit Window, it calls
;  SetMagicFocusArea to set the focus to a region surrounding the cursor position.
;  Test to determine if there is an application specific setting in the jcf file to disable the JFW tracking engine.
; Test for the existance of MAGic.  If MAGic is not running, return without doing any further processing.
Var Handle hWin, Int bSuccess, String strWinClass
If (!MagGetState () > 0) then Return EndIf
If (nX == nOldX && nY == nOldY) then 
	Return
EndIf
Let hWin = GetCurrentWindow ()
Let strWinClass = GetWindowClass (hWin)
If (strWinClass == WCField) then
	Let bSuccess = TrackDialogBoxes (nX, nY, nOldX, nOldY, nUnit, nDir, nTimeElapsed, GetWindowTypeCode (hWin), GetWindowClass (hWin), GetAppMainWindow (hWin))
	Return
ElIf (strWinClass == wcNotes) then
	Let bSuccess = TrackEditWindow (nX, nY, nOldX, nOldY, nUnit, nDir, nTimeElapsed, GetWindowTypeCode (hWin), GetWindowClass (hWin), GetAppMainWindow (hWin), 0)
	Return
EndIf
If (DialogActive ()) then
	Return
EndIf
If (DidControlChange () == 1) then
	Return
EndIf
If (GetWindowSubTypeCode (GetCurrentWindow ()) == WT_STARTMENU) then
	Return
EndIf
Let TargetItem = 0
If (GetCursorCol () - nX == 1) then
	Let nX = nX + 1
EndIf
;MagSetFocusArea (nX, nY, nOldX, nOldY, nUnit, nDir, nTimeElapsed, TargetItem)
EndFunction


Void Function NewTextMagEvent (handle hwnd, string buffer, int nAttributes, int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
;  When this function is called, it receives information pertaining to the newly written text.
;  It then analyzes the newly written text to determine if there is a need to adjust the
;  MAGic focus so that the newly written text is brought into view.
Var    String TheClass,    String cwClass,    Int TheTypeCode,     Int cwTypeCode,
  Int nH,    Int bSuccess,  Int nX,   Int nY, Handle prevWinHandle, int nLeft, int nTop,
  int nRight, int nBottom, Int nL, Int nR, Int nT, Int nB, Handle hWin
; Exit without any further processing if MAGic is not running
If (!MagGetState ()) then Return EndIf
; Innitialize the variables that must be initialized in order to make the decision about whether or not to allow the function to continue running first.
let TheClass = GetWindowClass(hwnd)
let TheTypeCode = GetWindowSubtypeCode (hwnd)
Let hWin = GetCurrentWindow ()
let cwClass = GetWindowClass (hWin)
let cwTypeCode = GetWindowSubtypeCode (hWin)
;  Allways allow NewTextMagEvent to control tracking in the start menu and the alt + tab dialog box
if ((cwTypeCode == WT_STARTMENU) && (nAttributes & ATTRIB_HIGHLIGHT)) then TrackStartMenu(hwnd, TargetItem) Let TargetItem = 0 Return EndIf
;wnAltTab="#32771"
If (TheClass == wnAltTab) then
	If (!GetWindowRect (hwnd, nL, nR, nT, nB)) then return EndIf
	let nH = nB - nT
	let nT = nT + ((50 * nH) / 100)
	MagSetFocusToRect (nL, nR + 10, nT, nB + 5, MTO_GENERIC)
	return
EndIf
;***  Make the decision about whether or not NewTextMagEvent is going to be allowed to continue running
; Exit without any further processing if either a menu or a menu bar is active
If (GlobalMenuMode != MENU_INACTIVE) then Return EndIf
; Exit without any further processing if the active control changed in dialog boxes since FocusChangedMagEvent will control MAGic tracking in dialog boxes when moving from control to control
If (DidControlChange () == 1) then Return EndIf
; Track movement in gmDlgBrowse windows
If (cwClass == wcGmDlgBrowse && DialogActive()) then
	Let nX = GetCursorCol ()
	Let nY = GetCursorRow ()
	TrackListView (nX, nY, 0, 0, 0, 0, 0, cwTypeCode, cwClass, 0, 0)
ElIf (cwClass == WCBrowse) then
	Let nX = GetCursorCol ()
	Let nY = GetCursorRow ()
	TrackListView (nX, nY, 0, 0, 0, 0, 0, cwTypeCode, cwClass, 0, 0)
EndIf
; Exit if the current window class is SysTreeView32, designed to speed up tracking in the Microsoft Outlook TreeView
If (cwClass == mWN_STV32) then Return EndIf
; Exit without any further processing if the window the new text was written to is not one of the windows that magConst.jsh specifies that
; NewTextMagEvent control tracking in
If !(StringContains (NewTextSetFocusWindows, TheClass) || StringContains (NewTextSetFocusWindows, "WT_" + IntToString (TheTypeCode))) then Return EndIf
;  The Windows 95 device manager is the only known example of a SysTreeViewClass in which FocusChangedMadEvent is not called when moving from
;  one item to another.  Therefore, return without further processing if in a window with a class of SysTreeView that is not in the Windows 95 device
;  manager
If (TheClass == mWN_STV) then
	If !(StringContains (GetWindowName (GetRealWindow (GetFocus ())), mWN_SysProperties)) then Return EndIf
Else EndIf
;  Exit without further processing if in a Word Perfect Edit window
If (StringContains (cwClass, mWN_WP)) then Return EndIf
;  Exit without further processing if in a combo box in a Microsoft Office dialog box and a caret is present
If (StringContains (TheClass, "bosa_sdm") && GetItemRect (nX, nY, nL, nR, nT, nB, IT_CARET) == TRUE) then Return EndIf
;  Initialize the remaining variables
Let TargetItem = 0
Let nteHandle = hwnd
Let nX = GetCursorCol ()
Let nY = GetCursorRow ()
;  Control tracking in the combo list box of Microsoft Office SDM dialogs
If (StringContains (TheClass, mWC_BosaSDM) && GetItemRect (nX, nY, nL, nR, nT, nB, IT_CARET) == FALSE) then
	GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT)
	MagSetFocusToRect (nL - 5, nR + 5, nT - 2, nB + 2, MTO_DIALOG)
	Return
; Control MAGic tracking in combo list boxes, specifically the combo list box in Windows Explorer
ElIf (TheClass == mWN_ComboLBox) then
	If (nAttributes & ATTRIB_HIGHLIGHT) then
		GetFocusRect (hwnd, nL, nR, nT, nB)
		MagSetFocusToRect (nL - 5, nR + 5, nT - 2, nB + 2, MTO_DIALOG)
		Return
	EndIf
	Return
;  Control MAGic tracking in Combo Boxes.  FocusPointMovedMagEvent is capable of controlling the tracking in Combo Boxes except when pressing
;  enter to make a selection or pressing escape to cancel.  In these circumstances, control the tracking in NewTextMagEvent by calling TrackDialogBoxes.
ElIf (cwClass == mWN_ComboBox || cwTypeCode == WT_COMBOBOX) then
	If (nAttributes & ATTRIB_HIGHLIGHT) then
		TrackDialogBoxes (nX, nY, 0, 0, 0, 0, 0, cwTypeCode, cwClass, GetAppMainWindow (GetCurrentWindow ()))
		Return
	EndIf
	Return
; Control MAGic tracking in the Windows 95 Device Manager
ElIf (TheClass == mWN_STV ) then
	GetItemRect (GetCursorCol (), GetCursorRow (), nL, nR, nT, nB, IT_FIELD)
	MagSetFocusToRect (nL - 5, nR + 5, nT - 2, nB + 2, MTO_DIALOG)
	Return
; Control MAGic tracking in Extended List Boxes
ElIf (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX) then
	GetItemRect (GetCursorCol (), GetCursorRow (), nL, nR, nT, nB, IT_BOUNDINGRECT)
	MagSetFocusToRect (nL - 5, nR + 5, nT - 5, nB + 5, MTO_CARET)
	Return
;  Control MAGic tracking in Microsoft Outlook list view or any other window of class SUPERGRID
ElIf (cwClass == "SUPERGRID") then
	If (nAttributes & ATTRIB_HIGHLIGHT) then
		GetLineRect (0, 0, nL, nR, nT, nB)
		MagSetFocusToRect (nL - 5, nR + 5, nT - 2, nB + 2, MTO_CARET)
		Return
	EndIf
; Control MAGic tracking in List Boxes
ElIf (TheClass == mWN_ListBox) then
	If (nAttributes & ATTRIB_HIGHLIGHT) then
		Let bSuccess = FALSE
		Let bSuccess = GetItemRect (GetCursorCol (), GetCursorRow (), nL, nR, nT, nB, IT_LINE)
		If (!bSuccess) then Let bSuccess = GetItemRect (GetCursorCol (), GetCursorRow (), nL, nR, nT, nB, IT_CHUNK)  EndIf
		Let nR = GetWindowRight (hwnd)
		MagSetFocusToRect (nL - 5, nR + 5, nT - 2, nB + 2, MTO_DIALOG)
		Return
	EndIf
Else
; Control magic tracking in any other window in which NewTextMagEvent is allowed to function
	If (nAttributes & ATTRIB_HIGHLIGHT) then
		GetItemRect (0, 0, nL, nR, nT, nB, IT_CHUNK)
		MagSetFocusToRect (nL - 5, nR + 5, nT - 2, nB + 2, MTO_DIALOG)
		Return
	EndIf
EndIf
EndFunction

Script Test ()
Say ("MAGic GoldMine Script Set Loaded", ot_message)
EndScript
